#pragma rtGlobals=1		// Use modern global access method.
Macro loadMicromeriticsV1_06()
	variable qloadall=2,linelimit=6000
	Prompt qLoadAll,"Load all data in a Folder?",popup,"All waves in folder (no Display);User picks waves one at a time (Displayed)"
	silent 1
	setdatafolder root:
	NewDataFolder/O MicromeriticsUC_SN_131
	variable index=0,Counter,length, refno,var, adder, killcounter
	String LineOfNote,HeaderText,name,rwave,swave,qwave,qmodwave,rmodwave,filename,samplename,path,fullpath,testnumstring,wavenames,qwavename,rwavename,swavename,wavenames1
	String qmodwavename, rmodwavename, qp1wavename, rp1wavename, qp2wavename, rp2wavename, qp1wave,rp1wave,qp2wave,rp2wave, literal1, literal2
	String/g Root:Packages:P:xvalue
	String/g Root:Packages:P:yvalue
	string/g Root:Packages:P:gYLabel="\F'arial'\Z18\f01Intensity"
	string/g Root:Packages:P:gXLabel="\F'arial'\Z18\f01q(A\S-1\M\Z18)"
	String Xa=Root:Packages:P:xvalue,Ya=Root:Packages:P:yvalue,yLabel=Root:Packages:P:gYLabel,xLabel=Root:Packages:P:gXLabel
	String xaxislabel, yaxislabel
	string/g Root:Packages:P:gfilename
	if (qloadall==2)//load one
		Open/R/T="TEXT"/m="Text file only" refno as filename//User picks a file
		getfilename(s_filename)
		fullpath=s_filename
		filename=Root:Packages:P:gfilename
		NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string
	else //load all pick folder
			NewPath/O temporarypath //User picks a folder, temporary path is not a defined string
	endif
	variable Totaltests=0, qspace=0
	do//cycle through all text files in folder
		if(qloadall==1)//loading all files
			filename=IndexedFile(temporarypath, index, ".txt")
				if (strlen(filename)==0)//any more files?
					Killvariables/a/z;killstrings/a/z
					break  //always exit here when files are exhausted
				endif
			Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
			getfilename(s_filename)
			fullpath=s_filename
		endif
		//put initial lines in note of wave and set up a data folder based on the sample ID in text file
		counter=0
		
		HeaderText=filename+"\r"
		do//get the header information
			FReadLine refNo, LineOfNote	
			HeaderText+=LineOfNote
				if (stringmatch(LineofNote, "*Sample*" ))
					print "sample line = "+lineofnote
					samplename=Getnamechanges(lineofnote)
					//length =strlen(lineofnote)
					//samplename=lineOfNote[10, (length-4)]
					samplename=CleanupName(samplename,0)	
				endif
			Counter+=1
		while(Counter<17)
		length =strlen(filename)
		name="M"+filename[4,(length-5)]+""+samplename//may have to eliminate more for .rep.text
		name=cleanupName(name,0)
		name=name[0,28]
		NewDataFolder/O/S $name
		make/o/n=8 tests
		//data loading
		variable/g obscuration
		
		do//find the background intensity
			FReadLine refno, LineOfNote
			counter=counter+1
			if (stringmatch(LineofNote, "*obscuration*" ))
				print lineofnote
				print lineofnote[23,27]
				obscuration=str2num(lineofnote[23,27])	
			endif
			If (stringmatch(LineofNote, "Background Intensity vs*" ))
				Print "\r"+(num2str(counter))+" "+lineofnote
				break 
			endif	
		while (counter<linelimit)		
		if (counter==linelimit)//exceeded the line limit must not be any more tests
			DoAlert 0, "Line limit exceeded. No backgrouund found."
			break
		endif
		//load the background waves
		LoadWave/n/g/k=1/L={0,(counter+4),465,0,2} fullpath
		make/o qzbkg,rzbkg,szbkg
		duplicate/o wave0,qzbkg;duplicate/o wave1,rzbkg;duplicate/o wave1 szbkg
		szbkg=0.01*szbkg
		qzbkg=(4*pi*1.33/6580)*sin (qzbkg*pi/360)

		//find a Sample waves
		totaltests=0
		adder =0
		var=0		
		killcounter = 0
		do//find goodness of fit and signal fraction
			FReadLine refNo, LineOfNote
			counter=counter+1
			if (stringmatch(LineofNote, "Goodness of Fit*" ))
				Print (num2str(counter))+" "+lineofnote
				LoadWave/n/g/n=w/k=1/L={0,(counter+2),0,0,2} fullpath//all the rest must be sample waves, load them
				wavenames=s_wavenames
			endif
			if (stringmatch(LineofNote, "Signal Fraction" ))
				Print (num2str(counter))+" "+lineofnote
				LoadWave/n/g/n=w/k=1/L={0,(counter+2),0,0,2} fullpath//all the rest must be sample waves, load them
				wavenames=s_wavenames				
			endif
			if (stringmatch(LineofNote, "Unified Model" ))
				Print (num2str(counter))+" "+lineofnote
				LoadWave/n/g/n=w/k=1/L={0,(counter+2),0,0,2} fullpath//all the rest must be sample waves, load them
				wavenames=s_wavenames				
			endif				
			If (stringmatch(LineofNote, "test*" ))//Does the line contain a test number?
				testnumstring = lineofnote[5]//pick off the test number
				tests[totaltests]=str2num(testnumstring)//tests is a wave that stores the test numbers
				totaltests=totaltests+1
			endif	
			If  (stringmatch(LineofNote, "Scattering vector*" ))//q or angle?
				qspace=1
			var=var+1
			killcounter =killcounter +1
			endif	
			if(stringmatch(LineofNote,"Smth*"))
				print lineofnote
				print lineofnote[8,14]
				print lineofnote[19,28]
				adder=adder+1
				if (adder==1)
				variable/g p1
				p1=str2num(lineofnote[8,14])
				variable /g  b1
				b1=(10^ (str2num(lineofnote[19,23])*(10^str2num(lineofnote[25,28]))))
				endif
				if(adder==2)
				variable/g p2, b2
				p2=str2num(lineofnote[8,14])
				b2=(10^(str2num(lineofnote[19,23])*(10^str2num(lineofnote[25,28]))))
				endif
			endif								
		while (counter<linelimit)
		//If(totaltests==0)
		//	DoAlert 0, "No Goodness of Fit Wave"
			//abort
	//	endif
		//parse the waves into tests
		counter = 0
		do
			if (totaltests!=0)
				testnumstring="_"+num2str(tests[counter])
			endif
			rwave="r"+name+testnumstring
			swave="s"+name+testnumstring
			qwave="q"+name+testnumstring
			make/o $qwave,$rwave,$swave
			if (totaltests != 0)
			qwavename= stringfromlist((4*counter),wavenames)
			rwavename=stringfromlist((1+4*counter),wavenames)
			swavename=stringfromlist((3+4*counter),wavenames)
			duplicate/o  $qwavename,$qwave
			else
			qmodwave="qmod"+name+testnumstring
			rmodwave="rmod"+name+testnumstring
			qp1wave="qp1"+name+testnumstring
			rp1wave="rp1"+name+testnumstring
			if(var==5)
			qp2wave="qp2"+name+testnumstring
			rp2wave="rp2"+name+testnumstring
			endif
			make/o $qmodwave,$rmodwave,$qp1wave,$rp1wave	
			qwavename= stringfromlist((10*counter),wavenames)
			rwavename=stringfromlist((1+10*counter),wavenames)
			swavename=stringfromlist((3+10*counter),wavenames)
			qmodwavename= stringfromlist((4+10*counter),wavenames)
			rmodwavename=stringfromlist((5+10*counter),wavenames)
			
			if(adder!=0)//if there is no power law regime or if the scattering angle is chosen instead of scattering vector
			qp1wavename=stringfromlist((6+10*counter),wavenames)
			rp1wavename=stringfromlist((7+10*counter),wavenames)
			duplicate/o  $qp1wavename,$qp1wave
			duplicate/o  $rp1wavename,$rp1wave
			endif		
			if(var==5)//counts the occurence of scattering vector If 4 one power law, if 5 two powver laws must be modifiied if more number of power laws are found
			make/o $qp2wave $rp2wave
			qp2wavename=stringfromlist((8+10*counter),wavenames)
			rp2wavename=stringfromlist((9+10*counter),wavenames)
			duplicate/o  $qp2wavename,$qp2wave
			duplicate/o  $rp2wavename,$rp2wave
			endif	
			duplicate/o  $qwavename,$qwave
			duplicate/o  $qmodwavename,$qmodwave
			duplicate/o  $rmodwavename,$rmodwave							
			endif	
			if (qspace==0)
				$qwave=(4*pi*1.33/6580)*sin ($qwave*pi/360)
			endif
			duplicate/o  $rwavename,$rwave
			if (stringmatch(swavename, "" ))
				duplicate/o  $rwavename,$swave
				$swave=0.01*$rwave
				doalert 0, "Error wave not found.  Dummy wave created."
			endif
			if (!stringmatch(swavename, "" ))
				duplicate/o  $swavename,$swave
			endif
			Note $rwave HeaderText
			If (counter==0)//first test
				Display $rwave vs $qwave
			     			else
				AppendToGraph $rwave vs $qwave
			endif	
			ChangetoLineandPoints(4,1)	
			ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
			AddErrorWaves()
			Legend/C/N=text1/A=MC
			counter=counter+1
		while (counter<(totaltests))//cycles through tests in same refno file
		
		duplicate rzbkg, rbk;duplicate qzbkg, qbk
		appendtograph rbk vs qbk
		close refno
		
		killwaves/Z wave0, wave1, w0, w1, w2, w3, w4, w5, w6, w7
		if (killcounter==5)
		killwaves/Z w8, w9
		endif
		if (Qloadall==1)
			//dowindow/k Graph0
		endif
		index=index+1
		Xa=qwave
		Ya=rwave
		Root:Packages:P:xvalue=Xa; Root:Packages:P:yvalue=Ya
		Display $Ya vs $Xa
		Legend/C/N=added2/J/A=MC"\\s('"+Ya+"')"+ya
		Modify log(bottom) =1
		Modify log(left)=1
		ModifyGraph log=1, tick=2,axThick=2,msize=2,mrkThick=3, mode=3,marker=19
		if(adder!=0)
			Xa=qp1wave
	             Ya=rp1wave
	             Append $Ya vs $Xa
		       ModifyGraph  log=1, tick=2,axThick=2,msize($Ya)=3,mrkThick=2, mode($Ya)=0,marker=19, rgb($Ya)=(0,65535,0), lSize=2, lStyle=0
		      // TextBox/C/N=text0/A=LT "P1= \ %g, B1 = \%g " 
    literal1="P1 = "+num2str(p1)+"\rB1 = "+num2str(b1)
    Tag $Ya,0,literal1///L=0  will remove arrow
	        endif
		if(killcounter==5)	
			Xa=qp2wave
			Ya=rp2wave
			Append $Ya vs $Xa
			ModifyGraph  log=1, tick=2,axThick=2,msize($Ya)=3,mrkThick=2, mode($Ya)=0,marker=19, rgb($Ya)=(0,0,65535), lSize=2, lStyle=0
			//TextBox/C/N=text1/A=MC "P2 = %g\rB2 = %g"
			
    literal2="P2 = "+num2str(p2)+"\rB2 = "+num2str(b2)
    Tag $Ya,0,literal2///L=0  will remove arrow

		endif
		
		Modify grid=2,tick=2,minor=1,font="Times",zero(left)=1,standoff=0, mirror=1;DelayUpdate
	 
	
	//xaxislabel="0"
	//yaxialabel="0"
	xaxislabel="\F'times new roman'\Z18\f01"+xlabel
	yaxislabel="\F'times new roman'\Z18\f01"+ylabel
	Label bottom xaxislabel;
	Label left yaxislabel;
	
	ShowInfo;ShowTools
	//ChangetoLineandPoints(modetype,1)
		
		
		setdatafolder root:
	while(qloadall==1)//don't recycle for single folder option
	if (qloadall==2)
	 	LoadMicromeriticsTXT(2)//allow user to hand pick another file
	endif	
end



function makemeasuredwave()
	string foldername=getdatafolder(0)
	string rwavename="r"+foldername[1,30]
	string qwavename="q"+foldername[1,30]
	string swavename="s"+foldername[1,30]
	print rwavename
	
	string measuredrwavename
	measuredrwavename =rwavename+"_mea"
	//wave rw=$rwavename
	
	duplicate/o $rwavename, $measuredrwavename
		
	string measuredqwavename
	measuredqwavename =qwavename+"_mea"
	duplicate/o $qwavename, $measuredqwavename
	
	string measuredswavename
	measuredswavename =swavename+"_mea"
	duplicate/o $swavename, $measuredswavename
	
	//Shortening rzbkg wave
	wave rzbkg
	variable nrzbkg=numpnts(rzbkg)
	
	wave mrw=$measuredrwavename
	variable nmrw=numpnts(mrw)
	
	variable nrdiff=nrzbkg-nmrw
	duplicate/o rzbkg, rzbkg_short
	DeletePoints 0,nrdiff, rzbkg_short
	
	mrw=mrw+rzbkg_short
	
	//Shortening qzbkg wave
	wave qzbkg
	variable nqzbkg=numpnts(qzbkg)
	
	wave mqw=$measuredqwavename
	variable nmqw=numpnts(mqw)
	
	variable nqdiff=nqzbkg-nmqw
	duplicate/o qzbkg, qzbkg_short
	DeletePoints 0,nqdiff, qzbkg_short
	
	mqw=mqw+qzbkg_short
	
	//Shortening szbkg wave
	wave szbkg
	variable nszbkg=numpnts(szbkg)
	
	wave msw=$measuredswavename
	variable nmsw=numpnts(msw)
	
	variable nsdiff=nszbkg-nmsw
	duplicate/o szbkg, szbkg_short
	DeletePoints 0,nsdiff, szbkg_short
	msw=msw+szbkg_short
endmacro
	


Macro loadMicromeriticsV1_08TXT(qloadall)
	variable qloadall=2,linelimit=2000
	Prompt qLoadAll,"Load all data in a Folder?",popup," User picks waves one at a time (Displayed)"
	variable plchecker, good
	silent 1
	setdatafolder root:
	NewDataFolder/O MicromeriticsUC_SN_131
	variable index=0,Counter,length, refno,var,  killcounter, Rgchecker,SdRgchecker, Rschecker
	variable nop
	String LineOfNote,HeaderText,name,rwave,swave,qwave,qmodwave,qpsdwave, rpsdwave,rmodwave,filename,samplename,path,fullpath,qpsdwavename,rpsdwavename,wavenames,qwavename,rwavename,swavename
	String qmodwavename, rmodwavename, qpwavename, rpwavename, qpwave,rpwave, literal
	String parameter, parm
	String/g Root:Packages:P:xvalue
	String/g Root:Packages:P:yvalue
	string/g Root:Packages:P:gYLabel="\F'arial'\Z18\f01Intensity"
	string/g Root:Packages:P:gXLabel="\F'arial'\Z18\f01q(\S-1\M\Z18)"
	string adder
	String Xa=Root:Packages:P:xvalue,Ya=Root:Packages:P:yvalue,yLabel=Root:Packages:P:gYLabel,xLabel=Root:Packages:P:gXLabel
	String xaxislabel, yaxislabel
	string/g Root:Packages:P:gfilename
	string rcolortypes="65535;0;0;65535;52428;0;39321;52428;1;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string gcolortypes="0;0;65535;43690;1;0;13101;52425;24548;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string bcolortypes="0;65535;0;0;41942;0;1;1;52428;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	
	variable red=FindString2num(0,rcolortypes,";")
	variable green=FindString2num(0,gcolortypes,";")
	variable blue=FindString2num(0,bcolortypes,";")
	
	if (qloadall==1)//load one
		Open/R/T="TEXT"/m="Text file only" refno as filename//User picks a file
		
		getfilename(s_filename)
		fullpath=s_filename
		filename=Root:Packages:P:gfilename

		NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string

	 else //load all pick folder
		NewPath/O temporarypath //User picks a folder, temporary path is not a defined string
	endif

counter=0
plchecker=0
		
		HeaderText=filename+"\r"
		do//get the header information
			FReadLine refNo, LineOfNote	
			HeaderText+=LineOfNote
				if (stringmatch(LineofNote, "*Sample*" ))
					//print "sample line = "+lineofnote
					samplename=Getnamechanges(lineofnote)
					//length =strlen(lineofnote)
					//samplename=lineOfNote[10, (length-4)]
					samplename=CleanupName(samplename,0)	
				endif
			Counter+=1
		while(Counter<17)
		length =strlen(filename)
		name="M"+filename[0,(length-5)]+""+samplename//may have to eliminate more for .rep.text
		name=cleanupName(name,0)
		name=name[0,28]		
		NewDataFolder/O/S $name		
	do//find goodness of fit and signal fraction
			FReadLine refNo, LineOfNote
			counter=counter+1
 
 // LOADING THE GOODNESS OF FIT, UNIFIED MODEL, PSD, POWER LAW REGIMES
 variable/g obscuration
variable/g Sample_Concentration

 			if (stringmatch(LineofNote, "*Sample Concentration*" ))
				print lineofnote
				print lineofnote[39,46]
				Sample_Concentration=str2num(lineofnote[39,46])
				
			endif
 			if (stringmatch(LineofNote, "*obscuration*" ))
				print lineofnote
				print lineofnote[23,27]
				obscuration=str2num(lineofnote[23,27])
				
			endif
 
			if (stringmatch(LineofNote, "Goodness of Fit*" ))
				//Print (num2str(counter))+" "+lineofnote
				//LoadWave/n/g/k=1/L={0,(counter+4),465,0,2} fullpath
				LoadWave/n/g/n=w/k=1/L={0,(counter+2),0,0,2} fullpath//all the rest must be sample waves, load them
				wavenames=s_wavenames
		        endif
		        make/o/t linereader
			//LOADING THE VALUES OF B, G, Rg
			if(stringmatch(LineofNote,"G*"))
				//print lineofnote
				//print lineofnote[3,3]
				linereader[plchecker] =lineofnote
				plchecker=plchecker+1 
				endif
				
			while(counter<linelimit)
				
							
				make/o/N=(plchecker-1) G, B, PLS, Rg, StdDevRg, Rs
				do
				lineofnote=(linereader[(nop+1)])
				//print lineofnote
				G[nop] = (str2num(LineofNote[3,6])*(10^str2num(lineofnote[8,10])))
					//g1=(str2num(LineofNote[3,6])*(10^str2num(lineofnote[8,10])))
					B[nop]=(str2num(LineofNote[16,19])*(10^str2num(lineofnote[21,23])))
					PLS[nop]=(str2num(LineofNote[28,31])*(10^str2num(lineofnote[33,35])))
					Rgchecker =  strsearch(LineofNote,"Rg",0)										
					SdRgchecker = strsearch(LineofNote,"StdDev(Rg)",0)
					Rschecker = strsearch(LineofNote,"Rs",0)
					Rg[nop]=str2num(LineofNote[(Rgchecker+3),(SdRgchecker-1)])
					StdDevRg[nop]=str2num(LineofNote[(SdRgchecker+11),(Rschecker-1)])
					Rs[nop]=str2num(LineofNote[(Rschecker+3),150])
												
					nop=nop+1
			while(nop<(plchecker-1))
				
		
		
		//ASSIGNING THE PROPER NAMES TO THE LOADED WAVES
		name= name[1,28]
		       rwave="r"+name
			qwave="q"+name
			swave="s"+name
			qmodwave="qmod"+name
			rmodwave="rmod"+name
			qpsdwave="qpsd"+name
			rpsdwave="rpsd"+name
			make/o $qwave,$rwave,$swave,$qmodwave,$rmodwave,$qpsdwave,$rpsdwave
			
			
			qwavename= stringfromlist((0),wavenames)
			rwavename=stringfromlist((1),wavenames)
			qmodwavename=stringfromlist((2),wavenames)
			rmodwavename=stringfromlist((3),wavenames)
			qpsdwavename=stringfromlist((4),wavenames)
			rpsdwavename=stringfromlist((5),wavenames)
					
			duplicate/o  $qwavename,$qwave
			duplicate/o  $rwavename,$rwave
			duplicate/o  $rwavename,$swave
			$swave*=.01
			duplicate/o  $qmodwavename,$qmodwave
			duplicate/o  $rmodwavename,$rmodwave
			duplicate/o  $qpsdwavename,$qpsdwave
			duplicate/o  $rpsdwavename,$rpsdwave
			
		Xa=qwave
		Ya=rwave
		Root:Packages:P:xvalue=Xa; Root:Packages:P:yvalue=Ya
		
		Display $Ya vs $Xa
		ModifyGraph log=1, tick=2,axThick=2,msize=2,mrkThick=3, mode=3,marker=19
		Legend/C/N=added2/J/A=MC"\\s('"+Ya+"')"+ya
	      Xa=qmodwave
		Ya=rmodwave
		Root:Packages:P:xvalue=Xa; Root:Packages:P:yvalue=Ya
	      Append $Ya vs $Xa
		//Legend/C/N=added2/J/A=MC"\\s('"+Ya+"')"+ya
		Modify log(bottom) =1
		Modify log(left)=1
		 ModifyGraph log=1, tick=2,axThick=2,msize=3,mrkThick=5, mode($Ya)=0,rgb($Ya)=(500,500,500),lSize=2, lStyle=0
		Xa=qpsdwave
		Ya=rpsdwave
		 Append $Ya vs $Xa
		ModifyGraph log=1, tick=2,axThick=2,msize=3,mrkThick=5, mode($Ya)=0,rgb($Ya)=(8000,500,500),lSize=2, lStyle($Ya)=3
		
		
		
			//ASSIGNING NAMES TO THE POWER LAW REGIMES 

nop = 0

do			
			
				adder = num2str(nop+1)
				print adder
				 rpwave="rp"+adder+name
				qpwave="qp"+adder+name
				make/o $rpwave $qpwave
				qpwavename= stringfromlist((6+(nop*2)),wavenames)
				rpwavename=stringfromlist((7+(nop*2)),wavenames)
				duplicate/o  $qpwavename,$qpwave
			      duplicate/o  $rpwavename,$rpwave
				
			Xa=qpwave
	             Ya=rpwave
	             Append $Ya vs $Xa
		      red=FindString2num((nop+1),rcolortypes,";")
			green=FindString2num((nop+1),gcolortypes,";")
			blue=FindString2num((nop+1),bcolortypes,";")
		      
		       ModifyGraph  log=1, tick=2,axThick=2,msize($Ya)=3,mrkThick=2, mode($Ya)=0,marker=19, rgb($Ya)=(red, green, blue), lSize($Ya)=2, lStyle($Ya)=0
		literal="P = "+num2str(PLS[nop]) +"\rB = "+num2str(B[nop]) +"\rG = "+num2str(G[nop])+"\rRg= "+num2str(Rg[nop])+"\rStdDevRg = "+num2str(StdDevRg[nop])+"\rRs = "+num2str(Rs[nop])
		Tag $Ya,0,literal///L=0  
		//ChangetoLineandPoints(1,1)
		nop =nop +1
				
		while(nop<(plchecker-1))
	
				
			
		//if (Qloadall==1)
			//dowindow/k Graph0
		//endif
		//index=index+1
		
       	
		Modify grid=2,tick=2,minor=1,font="Times",zero(left)=1,standoff=0, mirror=1;DelayUpdate
	 
	
	
	xaxislabel="\F'times new roman'\Z18\f01"+xlabel
	yaxislabel="\F'times new roman'\Z18\f01"+ylabel
	Label bottom xaxislabel;
	Label left yaxislabel;
	
	ShowInfo;ShowTools
	
		
		close refno
		killwaves/z w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w10, w11, w12, w13, w14, w15, linereader
		Newdatafolder /O/S Fitting_Parameters
		LoadWave/J/D/ n=W/K=0/L={0,0,0,0,2} 
		wavenames=s_wavenames
		rename W0 value
		rename W1 varname			
			
		setdatafolder root:
		
		//while(qloadall==1)//don't recycle for single folder option
	if (qloadall==1)
	 	LoadMicromeriticsV1_08TXT(1)//allow user to hand pick another file
	endif	
	end



Macro LoadInstronTXT(qloadall)
	variable new
	variable qloadall=2,linelimit=5000
	Prompt qLoadAll,"Load all data in a Folder?",popup,"All waves in folder (no Display);User picks waves one at a time (Displayed)"
	variable lfvar, dfvar
	silent 1
	setdatafolder root:
	//NewDataFolder/O MicromeriticsUC_SN_131
	variable index=0,Counter,length, refno,var, adder, killcounter, Rgchecker,SdRgchecker, Rschecker
		variable ar
	String LineOfNote,HeaderText,name,filename,samplename,path,fullpath,wavenames 
	String lwave, dwave, lwavename, dwavename
	String/g Root:Packages:P:xvalue
	String/g Root:Packages:P:yvalue
	string/g Root:Packages:P:gYLabel="\F'arial'\Z18\f01Stress (MPa)"
	string/g Root:Packages:P:gXLabel="\F'arial'\Z18\f01Strain  %"
	
	String Xa=Root:Packages:P:xvalue,Ya=Root:Packages:P:yvalue,yLabel=Root:Packages:P:gYLabel,xLabel=Root:Packages:P:gXLabel
	String xaxislabel, yaxislabel
	string/g Root:Packages:P:gfilename
	if (qloadall==2)//load one
		Open/R/T="TEXT"/m="Text file only" refno as filename//User picks a file
		
		getfilename(s_filename)
		fullpath=s_filename
		filename=Root:Packages:P:gfilename
		
		NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string
	      
	       	      
	 else //load all pick folder
		NewPath/O temporarypath //User picks a folder, temporary path is not a defined string
	endif
	
	do//cycle through all text files in folder
		if(qloadall==1)//loading all files
			filename=IndexedFile(temporarypath, index, ".txt")
				if (strlen(filename)==0)//any more files?
					Killvariables/a/z;killstrings/a/z
					break  //always exit here when files are exhausted
				endif
			Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
			getfilename(s_filename)
			fullpath=s_filename
		endif
counter=0

		HeaderText=filename+"\r"
		//do//get the header information
			//FReadLine refNo, LineOfNote	
			//HeaderText+=LineOfNote
				//if (stringmatch(LineofNote, "*Sample*" ))
					//print "sample line = "+lineofnote
					//samplename=Getnamechanges(lineofnote)
					//length =strlen(lineofnote)
					//samplename=lineOfNote[10, (length-4)]
					//samplename=CleanupName(samplename,0)	
				//endif
			//Counter+=1
		//while(Counter<17)
		length =strlen(filename)
		name=filename[0,(length-5)]//may have to eliminate more for .rep.text
		name=cleanupName(name,0)
		name=name[0,28]
		
		NewDataFolder/O/S $name
		
	
			FReadLine refNo, LineOfNote
			
  				LoadWave/a/g/n=w/k=1/L={0,(counter+8),0,0,3} fullpath//all the rest must be sample waves, load them
				wavenames=s_wavenames
		     
	     		do//find goodness of fit and signal fraction
			FReadLine refNo, LineOfNote
			print LineOfNote
			counter=counter+1
 
         			if(stringmatch(LineofNote,"*Width*"))
				variable /g width
				width = str2num(LineofNote[22, 31])
													
				endif
				if(stringmatch(LineofNote,"*Thickness*"))
				variable /g thickness
				thickness = str2num(LineofNote[22, 31])
												
				endif
			
			if (stringmatch(LineofNote,"*Spec gauge len:*"))
			variable /g l
			l = str2num(LineofNote[21,31])
			endif
			
				
		while (counter<1000)
		
		ar = width * thickness
			
			
		
		
		//ASSIGNING THE PROPER NAMES TO THE LOADED WAVES
		
			lwave="l_"+name
			dwave="d_"+name
			make/o $lwave,$dwave
			
			dwavename= stringfromlist((1),wavenames)
			lwavename=stringfromlist((2),wavenames)
			
			duplicate/o  $lwavename,$lwave
			duplicate/o  $dwavename,$dwave
			$lwave = ($lwave/ar)*1000
			lfvar = $lwave[0]
			$lwave = $lwave -lfvar
						
			
			$dwave = ($dwave/l)*100
			dfvar =$dwave[0]
			$dwave = $dwave - dfvar
			
		       
		if (Qloadall==1)
			//dowindow/k Graph0
		endif
		index=index+1
		//PLOTTING TO THE GRAPH
		Xa=dwave
		Ya=lwave
		Root:Packages:P:xvalue=Xa; Root:Packages:P:yvalue=Ya
		
		Display $Ya vs $Xa
		ModifyGraph  tick=2,axThick=2,msize=2,mrkThick=3, mode=0,marker=19
		Legend/C/N=added2/J/A=MC"\\s('"+Ya+"')"+ya		
		Modify grid=2,tick=2,minor=1,font="Times",zero(left)=1,standoff=0, mirror=1;DelayUpdate
		xaxislabel="\F'times new roman'\Z18\f01"+xlabel
	yaxislabel="\F'times new roman'\Z18\f01"+ylabel
	Label bottom xaxislabel;
	Label left yaxislabel;
	
	ShowInfo;ShowTools
	killwaves/z /a
		setdatafolder root:
		close refno
		while(qloadall==1)//don't recycle for single folder option
	if (qloadall==2)
	 	 LoadInstronTXT(2)//allow user to hand pick another file
	endif	
	end



functioin fixq()
	Setdatafolder root:
	Execute "SetOperationFolder()"
	string name=GetDataFolder(0)
	name="q"+name[1,50]
	wave qwave=$name
	qwave=1.33*qwave
	//qblank=1.33*qblank
	fixq()
end	
	
function fixratio()
	Setdatafolder root:
	Execute "SetOperationFolder()"
	string name=GetDataFolder(0)
	name="r"+name[1,50]
	wave Rwave=$name
	duplicate rwave, rfudged
		NVAR ratio
		 rwave[20]= rwave[20]/ratio
		 rwave[22]= rwave[22]/ratio
		 rwave[24]= rwave[24]/ratio
	ratio = 1
	
endmacro


Macro LoadHoriba910(qloadall,rspace,Liquid)
	variable qloadall=2,rspace=2,Liquid=1
	Prompt qLoadAll,"Load all data in a Folder?",popup,"All waves in folder (not displayed);User picks waves one at a time (displayed)"
	Prompt rspace,"Data Type?",popup, "r-space;q-space"
	Prompt Liquid,"Liquid or Powder?",popup, "Liquid;Powder"
	
	silent 1
	setdatafolder root:
		make/O/n=25 Root:Packages:P:qw,Root:Packages:P:solidangle,Root:Packages:P:qwpj
		//Root:Packages:P:qw[0,24]={0,5.31112E-07,7.7398E-07,1.08973E-06,1.53545E-06,2.1722E-06,3.07171E-06,4.34164E-06,6.13376E-06,8.66913E-06,1.2257E-05,1.73326E-05,2.45118E-05,3.46715E-05,4.90552E-05,6.94466E-05,9.84218E-05,0.000139807,0.000206082,0.000380317,0.000594234,0.000763522,0.00119298,0.001917245,0.002995636}
		//Following multiplies by 1.33 for water
		Root:Packages:P:qw[0,24]={0,7.064E-07,1.029E-06,1.449E-06,2.042E-06,2.889E-06,4.085E-06,5.774E-06,8.158E-06,1.153E-05,1.630E-05,2.305E-05,3.260E-05,4.611E-05,6.524E-05,9.236E-05,1.309E-04,1.859E-04,2.741E-04,5.058E-04,7.903E-04,1.015E-03,1.587E-03,2.550E-03,3.984E-03}
		Root:Packages:P:solidangle[0,24]= {0.000000000,0.000000120,0.000000219,0.000000519,0.000001080,0.000002421,0.000004749,0.000010236,0.000019754,0.000042102,0.000080825,0.000170848,0.000326905,0.000689220,0.001318455,0.002783982,0.005356499,0.011450379,0.028852138,0.001464158,0.001548829,0.00073287,0.000775233,0.003740288,0.003956474}
		//powder jet (PJ)
		Root:Packages:P:qwpj[0,24]={0,9.39E-07,1.37E-06,1.93E-06,2.72E-06,3.84E-06,5.43E-06,7.68E-06,1.09E-05,1.53E-05,2.17E-05,3.07E-05,4.34E-05,6.13E-05,8.68E-05,1.23E-04,1.74E-04,2.48E-04,3.66E-04,6.84E-04,1.07E-03,1.53E-03,2.39E-03,2.47E-03,3.85E-03}
		Root:Packages:P:qw[0]=NaN
	if(Liquid==1)
		NewDataFolder/O Liquid
	endif
		NewDataFolder/O Powder
	variable index=0,Counter,length, refno,num,lines
	String LineOfNote,HeaderText,filename,samplename,path,fullpath,yname,xname,rname,sname,qname
	string/g Root:Packages:P:gfilename
	if (qloadall==2)//load one
		Open/R/T="TEXT"/m="Text file only" refno as filename
	else 
		NewPath/O temporarypath //temporary path is not a defined string//asks for data folder
	endif
	do
		if(qloadall==1)//only for all files loaded
			filename=IndexedFile(temporarypath, index, "TEXT")
				if (strlen(filename)==0)
					Killvariables/a/z;killstrings/a/z
					break  //always exit here
				endif
			Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
		endif
	
		getfilename(s_filename)
		fullpath=s_filename
		filename=Root:Packages:P:gfilename[0, strlen(Root:Packages:P:gfilename)-5]//Clips DOS extension
		samplename="L"+filename
		print samplename
		if(rspace==1)//rspace only
			counter=0//put initial lines in notes are of wave
			HeaderText=filename+"\r"
			do
				FReadLine refNo, LineOfNote
				HeaderText+=num2str(counter)+" "+LineOfNote
				if (counter==9)
					samplename=filename
					If (Liquid==1)
						samplename+="_"+lineOfNote[31,100]
						samplename=samplename[0,strlen(samplename)-2]
					endif
				endif
				Counter+=1	
			while(Counter<42+6*(Liquid-1))
		endif
		setdatafolder root:
		 samplename=AskName(samplename)
		 if (stringmatch(samplename, "" ))
		 	break
		 endif
		 samplename=samplename[1,30]
		NewDatafolder/o/s $samplename
		rname="r"+samplename;sname="s"+samplename;qname="q"+samplename
		
		if (rspace==2)//do this in q space
			If (liquid==1)
				LoadWave/J/Q/o/A=WA/o/K=1/V={" "," $",0,1}/L={0,4,5,0,0} fullpath
				LoadWave/J/Q/o/A=WB/o/K=1/V={" "," $",0,1}/L={0,9,0,0,0}fullpath
				Make/n=4/o OW;make/o/n=25 CW,GW
	
				CW[1,2]=WA2[p-1];CW[3]=WA2[4];CW[4,6]=WB2[p-4];CW[7]=WB2[p+2];CW[8,9]=WB2[p-1];CW[10,18]=WB2[p]
				CW[19]=wa4[0];CW[20]=WA2[1];CW[21]=wa2[2];CW[22]=wb4[0];	cw[23]=wb4[1];cw[24]=wb2[5]
		
				GW[1,2]=wa6[p-1];GW[3]=wa4[p+1];GW[4,5]=wb6[p-4];GW[6]=wb4[p-4];GW[7]=wb2[p-1]
				GW[8]=wb4[p-1];GW[9]=wb5[p-1];GW[10]=wb6[p];GW[11,18]=wb4[p];GW[19]=wb2[3]
				GW[20]=wb1[4];GW[21]=wa4[2];GW[22,23]=wb8[p-22];GW[24]=wb6[2]
				//GW[23]=NaN;GW[24]=NaN
	
				OW[0]=wb3[8];OW[1]=wb4[10];OW[2]=wb8[10];OW[3]=wb6[11]
				variable/g transLaser=OW[2],transLamp=OW[3],RH=OW[0],RL=OW[1],ratio=1//RL/RH tries to normalize lamp intensities.

				KillWaves  wa2,wa4,wa6,wb1,wb2,wb3,wb4,wb5,wb6,wb8
				Duplicate/O Root:Packages:P:qw,$qname//qwave is calculated in excel and put in igor by hand,  Originally forgot to multiply by 1.33
			else//powderjet
				LoadWave/J/Q/A=W/O/K=1/V={" "," $",0,1}/L={0,4,0,1,0} fullpath
				make/o/n=25 CW=NaN,GW=NaN
				CW[1,18]=W1[p-1];CW[19]=W3[0];CW[21]=W3[2];CW[23]=W3[4]
				variable/g RH=W3[8], RL=W5[3],translaser=W5[9],transLamp=1,ratio=1//RL/RH tries to normalize lamp intensities.
								print ratio
				GW[1]=W5[0];GW[2]=W3[1];GW[3]=W5[2];GW[4]=W3[3];GW[5]=W5[4];GW[6,8]=W3[p-1];GW[9]=W5[8];GW[10,18]=w3[p-1]
				GW[19]=W7[0];GW[21]=W5[1];GW[23]=W7[2]
				Duplicate/O Root:Packages:P:qwpj,$qname//qwave is calculated in excel and put in igor by hand powder jet is different from liquid cell.
			endif
			
			
			make/o/n=25 rblank=CW/Root:Packages:P:solidangle
			GW=GW/translaser
			GW[20]=ratio*GW[20]/(translamp/translaser)//fudging starts here
			GW[22]=ratio*GW[22]/(translamp/translaser)
			GW[24]=ratio*GW[24]/(translamp/translaser)
			make/o/n=25 $rname=GW/Root:Packages:P:solidangle//make rwave and normalize by solid angle
			killwaves/z OW,W1,W3,W5,W7,W2,W4,W6,W8//,GW,CW
			 ZapNegatives($rname,$rname,$rname)
			make/o/n=25 $sname=(abs($rname))^.5
			Duplicate/O Root:Packages:P:qw,$qname//qwave is calculated in excel
			
			LogLogPlot(qname,rname,1,1,4,1)
			ChangetoLineandPoints(4,1)
		else //rspace
			Lines=43+(Liquid-1)*6
			LoadWave/J/Q/A=wave/K=1/V={" "," $",0,1}/L={0,lines,0,1,0}  fullpath
			ConcatenateWaves("wave0","wave3")//size x
			ConcatenateWaves("wave1","wave4")//probability y
			num=numpnts(wave0)
			yname="P_"+samplename
			xname="D_"+samplename
			make/o/n=(num) $yname=wave1[num-p-1]
			make/o/n=(num) $xname=wave0[num-p-1]
			Killwaves wave0,wave1, wave2,wave3,wave4,wave5,wave6
			Note $yname, HeaderText
			If(qloadall==2)
				Display $yname vs $xname as samplename
				ModifyGraph log(bottom)=1
				Label left "P(D)";DelayUpdate
				Label bottom "Diameter (m)"
			endif
		
		endif
		index=index+1
		close refno
	while(qloadall==1)
end


Macro FixNamesNSLS(transmission)
	variable transmission=1
	prompt transmission, "Enter transmission"
	
	SetOperationFolder()
	string/g basename=getdatafolder (0)
	string newfolder="X"+basename
	print newfolder
	RenameDataFolder folder,($newfolder)
	variable/g Transmission=Transmission

	string rwave="r"+basename
	string rname=rwave+"_avg"
	Duplicate/O $rwave, $rname; KillWaves rwave
	variable/g/o Transmission=transmission,realtime=settings[5]
endmacro

Macro Load1dNSLSSAXS(qloadall)
	variable qloadall=2
	Prompt qLoadAll,"Load all data in a Folder?",popup,"All waves in folder (not displayed);User picks waves one at a time (displayed)"
	
	silent 1
	setdatafolder root:
	NewDataFolder/O NSLSSAXS_5_26_01
	variable index=0,Counter,length, refno,uquit,filenum=0
	String LineOfNote,HeaderText,name,rwave,swave,qwave,filename,samplename,path,fullpath
	string/g Root:Packages:P:gfilename
		if (qloadall==2)//load one
			Open/R/T="TEXT"/m="Text file only" refno as filename
			getfilename(s_filename)
			fullpath=s_filename
			filename=Root:Packages:P:gfilename
			NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string
		else //load all
			NewPath/O temporarypath //User selects path,temporary path is not a defined string
		endif
	do
		if(qloadall==1)
			filename=IndexedFile(temporarypath, index, "TEXT")
			//print" indexed filename = "+filename
				if (strlen(filename)==0)
					Killvariables/a/z;killstrings/a/z
					break  //always exit here
				endif
			Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
			getfilename(s_filename)
			fullpath=s_filename
		endif
	//read header file		
		counter=0//put initial lines in notes are of wave
		HeaderText=filename+"\r\r"
			do
				FReadLine refNo, LineOfNote
				HeaderText+=LineOfNote
					if (counter ==6)
						length =strlen(lineofnote)
						samplename=lineOfNote[7, (length-2)]			
					endif
				Counter+=1	
			while(Counter<7)
		close refno
	//get ready to read data file
		filename=filename[0,4]+"1"+filename[6,9]
		fullpath =Root:Packages:P:gpath+filename
		Open /R/Z=1/T="TEXT"/m="Text file only"/P=temporarypath refno as fullpath
		name=filename[0,5]+"_"+samplename
		name=CleanupName(name[0,28],0)
		NewDataFolder/O/S $name
		LoadWave/a/J/Q/D/K=0 fullpath
		//LoadWave/a/D/g/L={0,11,0,0,3} fullpath
		rwave="r"+name[0,28]
		swave="s"+name[0,28]
		qwave="q"+name[0,28]
		make/o $qwave,$rwave,$swave
		duplicate/o wave0,$qwave;duplicate/o wave0,$rwave;duplicate/o wave0,$swave
		$swave=(wave0^.5)
		$qwave = (p-20.03)*0.0006919//peak pixel and delta q/pixel
		make/o/n=(numpnts($qwave)) hiq
		hiq=(p-285.2)/114.4
		$qwave(495,10000)=hiq(p)
		killwaves hiq
		Note $rwave HeaderText
		killwaves wave0
		if (1024<numpnts($rwave))
			parseNSLS(rwave,qwave,swave)	//more than one run				
		endif
		index=index+1
		if (qloadall==2)
			if (waveexists($rwave)==1)
				display $rwave vs $qwave
				ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
				TextBox/C/N=text0/A=MC name		
			endif
		endif
//get ready to read settings file
		filename=filename[0,4]+"2"+filename[6,9]
		fullpath =Root:Packages:P:gpath+filename
		Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename	
		LoadWave/a/D/g	fullpath
		killwaves/z settings
		rename wave0, settings
		close refno
		index=index+2
		setdatafolder root:
	while(qloadall==1)
	if (qloadall==2)
	 	Load1dNSLSSAXS(2)
	endif	
end

macro parseNSLS(rwave,qwave,swave)
	string rwave,qwave,swave
	
	variable num=0
	variable numwaves=(numpnts($rwave))/1024
	string newrwave,newswave,newqwave
	do
		if ($rwave[50+num*1024]==0)
			break		
		endif
		newrwave=rwave[0,26]+"_"+num2str(num)
		newqwave=qwave[0,26]+"_"+num2str(num)
		newswave=swave[0,26]+"_"+num2str(num)
		make/n=1024/o $newrwave,$newqwave,$newswave
		$newrwave=$rwave[P+num*1024]
		$newswave=$swave[P+num*1024]
		$newqwave=$qwave[P]
		num=num+1			
	while (num<numwaves)	
	killwaves $rwave,$swave,$qwave
end

 Macro SplitNSLS()
	SetOperationFolder()
 		If (waveexists(Root:Packages:P:csrs)==0)
			make/n=4 Root:Packages:P:csrs
			Root:Packages:P:csrs[0]={21,428,496,945}//initial guess at cursor position
		endif
		If (exists("Root:Packages:P:shift")==0)
			variable/g Root:Packages:P:shift=.0025//multiply WAXS by this factor as default
		endif
		SplitNSLS2()
 
 
Macro SplitNSLS2(rwavename,shift)
	string rwavename
	variable shift=Root:Packages:P:shift
	Prompt shift,"Shift Hi Q by Factor of"
	Prompt rwavename,"Enter the Ycolumn:",popup,WaveList("R*", ";", "")
	
	Root:Packages:P:shift=shift
	string qwavename,swavename
	if (strlen(rwavename)>30)
		doalert 0,"wavename too long"
	endif
	qwavename="q"+rwavename[1,30]
	swavename="s"+rwavename[1,30]

	string rSAXwavename, rWAXwavename,qSAXwavename, qWAXwavename,sSAXwavename, sWAXwavename
	rSAXwavename="rS"+rwavename[1,30];sSAXwavename="sS"+swavename[1,30];qSAXwavename="qS"+qwavename[1,30]
	rWAXwavename="rW"+rwavename[1,30];sWAXwavename="sW"+swavename[1,30];qWAXwavename="qW"+qwavename[1,30]
	Duplicate/o $rwavename, $rSAXwavename;Duplicate/o $qwavename, $qSAXwavename;Duplicate/o $swavename, $sSAXwavename
	Duplicate/o $rwavename, $rWAXwavename;Duplicate/o $qwavename, $qWAXwavename;Duplicate/o $swavename, $sWAXwavename

	display $rSAXwavename vs $qSAXwavename 
		ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
		//TextBox/C/N=text0/A=MC rwavename
			CursorWait(rSAXwavename,Root:Packages:P:csrs[0],Root:Packages:P:csrs[1])
			Root:Packages:P:csrs[0]={PCSR(A),PCSR(B)}
			DeletePointsUsingCSRS(2,1)
		dowindow/k graph0
	display $rWAXwavename vs $qWAXwavename 
		ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
			CursorWait(rWAXwavename,Root:Packages:P:csrs[2],Root:Packages:P:csrs[3])
			Root:Packages:P:csrs[2,3]={PCSR(A),PCSR(B)}
			DeletePointsUsingCSRS(2,1)
		$rWAXwavename*=Root:Packages:P:shift
		$sWAXwavename*=Root:Packages:P:shift
		duplicate/o $qWAXwavename, ThetaWAX
		ThetaWAX=2*asin(1.366*$qWAXwavename/(4*pi))
		$rWAXwavename=$rWAXwavename/cos(ThetaWAX)
		killwaves ThetaWAX
	Appendtograph $rSAXwavename vs $SWAXwavename
	ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
	note  $sWAXwavename,"WAX X = "+ num2str(Root:Packages:P:shift)
	Cursor/P A,$rWAXwavename, 1
	Cursor/P B, $rSAXwavename,numpnts($rSAXwavename)-1
	print rwaxwavename
	print rsaxwavename
	CombineTwoCurveswCSRS(rWAXwavename,rSAXwavename,2,rwavename)
end

Macro load2dORNLSAXS(qloadall)
	variable qloadall=2,row
	Prompt qLoadAll,"Load all data in a Folder?  TEXT only",popup,"All waves in folder (not displayed);User picks waves one at a time (displayed)"
	
	silent 1
	setdatafolder root:
	NewDataFolder/O LogIntensty
	variable index=0,Counter,length, refno,uquit
	String/g HeaderText
	String LineOfNote,name,rwave,swave,qwave,filename,samplename,path,fullpath
	string/g Root:Packages:P:gfilename
		if (qloadall==2)//load one
			Open/R/T="TEXT"/m=".TXT(PC) or TEXT (Mac) file only" refno as filename
			getfilename(s_filename)
			fullpath=s_filename
			filename=Root:Packages:P:gfilename
			NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string
			
		else //load all
			NewPath/O temporarypath //temporary path is not a defined string
		endif
	do  //header part
			if(qloadall==1)
				filename=IndexedFile(temporarypath, index, "TEXT")
				//print filename
					if (strlen(filename)==0)
						Killvariables/a/z;killstrings/a/z
						break  // exit here
					endif
				Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
				getfilename(s_filename)
				fullpath=s_filename
			endif
		counter=0//put initial lines in notes are of wave
		HeaderText=filename+"\r\r"
		do
			FReadLine refNo, LineOfNote					
			if (counter>1059)//1059 or3110) Start of header
				HeaderText=HeaderText+LineofNote
				//print num2str(counter)+"  "+Lineofnote
				if (counter ==1061)//1061 or 3112  line containing run name
					length =strlen(lineofnote)
					name=Root:Packages:P:gfilename[0,(strlen(Root:Packages:P:gfilename)-5)]+"_"+(lineOfNote[12, (length-2)])
					name="O"+name[0,31]
					name=cleanupName(name,0)			
				endif
			endif
			Counter+=1	
		while (Counter<3127)//1081  Length of file
		close refno
		
		NewdataFolder/O/S $name
		LoadWave/G/M/Q/D/A=wave/L={0,34,1024,0,0} fullpath//data part
		make/o/n=(64,64) w
		make/o/n=4 w2
		row=0
		do	
			make/o/n=0 w1
			counter=0
			do
				w2=wave0[(16*row)+counter][p]
				ConcatenateWaves("w1", "w2")
				counter=counter+1
			while (counter<16)		
			w[row][]=w1[q]
			row=row+1				
		while (row<=63)	
		matrixtranspose w
		name="i"+name[1,32]
		make/o/n=(64,64) $name=w
		Note $name HeaderText
		killwaves w1,w2,wave0,w
		

		index=index+1
			if (qloadall==2)
				duplicate/o $name,itemp
				itemp=log(itemp)
				ilogwave=log($name)
				Display;AppendImage itemp;DelayUpdate
				ModifyImage Itemp ctab= {*,*,YellowHot,0}
				ModifyGraph width=288,height=288
				TextBox/C/N=text0/A=MT name
				break	
			endif
		setdatafolder root:
	while(1)
	//doalert 0, "Log of the wave isplotted"
	if (qloadall==2)
		 load2dORNLSAXS(2)
	endif	
end




Macro load2dORNL_Ordella(qloadall)
	variable qloadall=2,row
	Prompt qLoadAll,"Load all .xpt files in a Folder? ",popup,"All .xpt files in folder;User picks .xpt files one at a time"
	
	silent 1
	setdatafolder root:
	NewDataFolder/O/S Ordella
	variable index=0,Counter,lines, refno,size,lineno
	String LineOfNote,name,rwave,swave,qwave,filename,path,fullpath,HeaderText,windname,info
	string/g Root:Packages:P:gfilename
		if (qloadall==2)//load one
			Open/R/T=".xpt"/m=".xpt(PC)  file only" refno as filename
			getfilename(s_filename)
			fullpath=s_filename
			filename=Root:Packages:P:gfilename
			print filename
			NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string
			
		else //load all
			NewPath/O temporarypath //temporary path is not a defined string
		endif
	do  //header part
			if(qloadall==1)//load all
				setdatafolder Root:Ordella
				filename=IndexedFile(temporarypath, index, ".xpt")
					if (strlen(filename)==0)
						Killvariables/a/z;killstrings/a/z
						break  // exit here
					endif
				Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
				getfilename(s_filename)
				fullpath=s_filename
			endif
		counter=0
		HeaderText=filename+"\r\r"
		
		do//put initial lines in notes are of wave
			FReadLine refNo, LineOfNote					
			HeaderText=HeaderText+LineofNote
			//print num2str(counter)+"  "+Lineofnote
			if (counter==2)
				info=lineofnote
			endif
			if (counter==3)
				size=str2num(lineofnote[0,3])
				 lines=(size*size)/16
				 print size
				 print lines
			endif
			Counter+=1	
		while (Counter<6)
		name=Root:Packages:P:gfilename[0,(strlen(Root:Packages:P:gfilename)-5)]
		name="O"+name[0,31]
		name=cleanupName(name,0)	
		close refno
		
		NewdataFolder/O/S $name
		variable/g transmission=1,thickness=1,livetime=1,absI=1,xcenterlcl=1,ycenterlcl=1
		string/g sampleinfo=info, basename=name[1,100]
		LoadWave/G/M/Q/D/A=wave/L={0,6,lines,0,0} fullpath//data part
		make/o/n=(size,size) w
		make/o/n=16 w2
		row=0

		do	
			make/o/n=0 w1
			counter=0
			do
				lineno=((size/16)*row)+counter
				w2=wave0[lineno][p]
				ConcatenateWaves("w1", "w2")
				counter=counter+1
			while (counter<(size/16))		
			w[row][]=w1[q]
			row=row+1				
		while (row<=(size-1))	
		matrixtranspose w
		name="i"+name[1,32]
		make/o/n=(size,size) $name=w
		Note $name HeaderText
		killwaves w1,w2,wave0,w
		index=index+1
			if (qloadall==2)
				duplicate/o $name,itemp
				itemp=log(itemp)
				Display/k=1/N=$name;AppendImage itemp
				ModifyImage Itemp ctab= {*,*,YellowHot,0}
				ModifyGraph width=288,height=288
				windname=WinName(0,1)
				TextBox/W=$windname/N=text10/A=MT name
				DoUpdate
				break	
			endif
		setdatafolder root:
	while(1)
	//doalert 0, "Log of the wave isplotted"
	if (qloadall==2)
		load2dORNL_Ordella(2)
	endif	
end


macro load1dLANL_SANS()
	variable index=0,Counter,length, refno, nameline=0,nocols=4
	String LineOfNote,name,samplename="",fullpath,LineOfNote2,LineOfNote3,LineOfNote4,LineOfNote5,headertext,filetype=".col"
	IR1D_InitDataManipulation()
	setdatafolder root:
		if (!DataFolderExists("root:P"))		
				NewDataFolder/O root:P
		endif			
	string root:filename
	string root:path	
		Open/R/T=filetype/m=filetype refno as filename
		getfilename(s_filename)
		fullpath=s_filename
		//NewPath/O temporarypath path	
	string/g filename=s_filename

		setdatafolder Root:Packages:P:
		counter=0
	variable len,endname
	filename=getfilename(s_filename)
		counter=0
		HeaderText=""
		do
				FReadLine refNo, LineOfNote
					if (counter ==0)//picks sample name out of this line
						variable n=strsearch(Lineofnote, "$",0)-2
						lineofnote=lineofnote[0,n]+lineofnote[n+10,inf]
						lineofnote=lineofnote[5,9]+"_"+lineofnote[14,inf]
						lineofnote="r"+lineofnote				
						n=strsearch(Lineofnote, "Note",0)-11
					If(!n==-1)
						lineofnote=lineofnote[0,n]
					endif		
						samplename=AskName(lineofnote,name,28)	
						samplename="N_"+samplename[1,inf]		
					endif
					HeaderText+=lineofnote
					Counter+=1
		while(Counter<5)  //last line of header	
		//Headertext+="\r;BackgroundSubtrated=0;RunSubtracted=none;"			
	close refno
	string foldername=samplename
		setdatafolder root:
		if (!DataFolderExists("root:LANL_LQD"))		
				NewDataFolder/O root:LANL_LQD
		endif
		setdatafolder root:LANL_LQD
		NewDataFolder/O/S $foldername		
		variable/g thickness=getparameter("Enter Thickness in cm for "+samplename,1)
		killstrings/z root:filename,root:path
//Reducing the waves: data in absolue units(dsigma/domege)*(1/A)
		LoadWave/q/a/D/g/L={0,counter,200,0,nocols} fullpath

		string rwave, qwave, swave, ewave
		rwave="r_"+samplename[2,inf]
		swave="s_"+samplename[2,inf]
		qwave="q_"+samplename[2,inf]
		ewave="e_"+samplename[2,inf]	
		wave1=wave1/thickness
		wave2=wave2/thickness
		duplicate/o wave1,$rwave
		duplicate/o wave1,R_orig
		
		duplicate/o wave0,$qwave
		duplicate/o wave2,$swave//STDEV column in raw file
		duplicate/o wave3, $ewave//RMSBIN column in raw file
		Note $qwave, HeaderText
		Note $rwave, HeaderText
		Note $swave, HeaderText
		Note $ewave, HeaderText
		
		
		plotdata(rwave,qwave,samplename)		
		killwaves/z wave0, wave1, wave2, wave3
		string/g root:Packages:SASDataModification:IntensityWaveName=rwave	
		string/g root:Packages:SASDataModification:QWavename=qwave	
		string/g root:Packages:SASDataModification:ErrorWaveName	=swave
		string/g root:Packages:SASDataModification:DataFolderName=getdatafolder(1)
		variable t=thickness
		variable/g root:Packages:SASDataModification:Data1_Thickness= t
		variable/g Thickness_Orig=t
end



Macro loadMicromeriticsV1_08temp(qloadall)
	variable qloadall=2,linelimit=5000
	Prompt qLoadAll,"Load all data in a Folder?",popup," User picks waves one at a time (Displayed)"
	variable plchecker, good
	silent 1
	setdatafolder root:
	NewDataFolder/O MicromeriticsUC_SN_131
	variable index=0,Counter,length, refno,var,  killcounter, Rgchecker,SdRgchecker, Rschecker
	variable nop
	String LineOfNote,HeaderText,name,rwave,swave,qwave,qmodwave,qpsdwave, rpsdwave,rmodwave,filename,samplename,path,fullpath,qpsdwavename,rpsdwavename,wavenames,qwavename,rwavename,swavename
	String qmodwavename, rmodwavename, qpwavename, rpwavename, qpwave,rpwave, literal
	String parameter, parm
	String/g Root:Packages:P:xvalue, Root:Packages:P:yvalue,Root:Packages:P:gYLabel="\F'arial'\Z18\f01Intensity",Root:Packages:P:gXLabel="\F'arial'\Z18\f01q(\S-1\M\Z18)"
	string adder
	String Xa=Root:Packages:P:xvalue,Ya=Root:Packages:P:yvalue,yLabel=Root:Packages:P:gYLabel,xLabel=Root:Packages:P:gXLabel
	String xaxislabel, yaxislabel
	string/g Root:Packages:P:gfilename
	string rcolortypes="65535;0;0;65535;52428;0;39321;52428;1;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string gcolortypes="0;0;65535;43690;1;0;13101;52425;24548;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	string bcolortypes="0;65535;0;0;41942;0;1;1;52428;26214;65535;0;0;65535;52428;0;39321;52428;1;26214"
	variable red=FindString2num(0,rcolortypes,";")
	variable green=FindString2num(0,gcolortypes,";")
	variable blue=FindString2num(0,bcolortypes,";")
	if (qloadall==1)//load one
		Open/R/T="TEXT"/m="Text file only" refno as filename//User picks a file	
		getfilename(s_filename)
		fullpath=s_filename
		filename=Root:Packages:P:gfilename	
		NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string      	      
	 else //load all pick folder
		NewPath/O temporarypath //User picks a folder, temporary path is not a defined string
	endif
	//do//cycle through all text files in folder
		//if(qloadall==1)//loading all files
		//	filename=IndexedFile(temporarypath, index, ".txt")
			//	if (strlen(filename)==0)//any more files?
			//		Killvariables/a/z;killstrings/a/z
			//		break  //always exit here when files are exhausted
			//	endif
		//	Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
		//	getfilename(s_filename)
		//fullpath=s_filename
		//endif
	counter=0
	plchecker=0
		HeaderText=filename+"\r"//Header should be put in as a note in intensity data
		do//get the header information
			FReadLine refNo, LineOfNote	
			HeaderText+=LineOfNote
				if (stringmatch(LineofNote, "*Sample*" ))
					samplename=Getnamechanges(lineofnote)//could be cleaned up.  remove sample ID		
					samplename=CleanupName(samplename,0)	
				endif
			Counter+=1
		while(Counter<17)
		length =strlen(filename)//+filename[0,(length-5)]+""
		name="M_"+samplename//may have to eliminate more for .rep.text
		name=cleanupName(foldername,0)
		name=name[0,28]
		NewDataFolder/O/S $name
		variable/g obscuration, Sample_Concentration
		variable  startline, endline
	do//find goodness of fit and signal fraction
			FReadLine refNo, LineOfNote
			counter=counter+1
 			if (stringmatch(LineofNote, "*Sample Concentration*" ))
				print lineofnote
				print lineofnote[39,46]
				Sample_Concentration=str2num(lineofnote[39,46])			
			endif
 			if (stringmatch(LineofNote, "*obscuration*" ))
				print lineofnote
				print lineofnote[23,27]
				obscuration=str2num(lineofnote[23,27])		
			endif
			If (stringmatch(LineofNote, "*Particle Diameter*" ))//look for mie size distributions
				Print "\r"+(num2str(counter))+" "+lineofnote
				Print "start"
				print counter
				 startline=counter
				do	
					FReadLine refNo, LineOfNote
					counter=counter+1
					If (stringmatch(LineofNote, "\r" ))
						print "end"
						 endline=(1+counter)-startline
						 print endline
						LoadWave/n/g/A=miepsd/k=1/L={0,startline,endline,0,2} fullpath
						//add code to change names to match protocol  r_mie_name_testno and qmie_name_testno
						break
					endif
				while(1)
			endif
			If (stringmatch(LineofNote, "Background Intensity vs. Angle*" ))//load the background waves
				//Print "\r"+(num2str(counter))+" "+lineofnote
				LoadWave/n/A=bkwave/g/k=1/L={0,(counter+4),465,0,2} fullpath
				//make/o qzbkg,rzbkg,szbkg
				duplicate/o bkwave0,qzbkg;duplicate/o bkwave1,rzbkg;duplicate/o bkwave1 szbkg
				szbkg=0.01*szbkg//dummy error wave
				qzbkg=(4*pi*1.33/6580)*sin (qzbkg*pi/360)//assumes water
				//max read the actual refractive index from header
				killwaves bkwave0, bkwave1
			endif	
			
			//if (counter==linelimit)//exceeded the line limit must not be any more tests
				//DoAlert 0, "Line limit exceeded. No backgrouund found."
				//break
			//endif
			if (stringmatch(LineofNote, "Goodness of Fit*" ))
			//LoadWave/n/g/k=1/L={0,(counter+4),465,0,2} fullpath
				LoadWave/n/g/n=w/k=1/L={0,(counter+2),0,0,2} fullpath//all the rest must be sample waves, load them
				wavenames=s_wavenames
		        endif
		        make/o/t/n=10 linereader//max,  look for G: 
			if(stringmatch(LineofNote,"G*"))//LOADING THE VALUES OF B, G, Rg
				linereader[plchecker] =lineofnote//count the number of G* found.  One more than the number of levels
				plchecker=plchecker+1 
			endif			
	while(counter<linelimit)		//get the unified parameters					
				make/o/N=(plchecker) G, B, PLS, Rg, StdDevRg, Rs
				do
				lineofnote=(linereader[(nop+1)])
				print lineofnote
				G[nop] = (str2num(LineofNote[3,6])*(10^str2num(lineofnote[8,10])))
					//g1=(str2num(LineofNote[3,6])*(10^str2num(lineofnote[8,10])))
					B[nop]=(str2num(LineofNote[16,19])*(10^str2num(lineofnote[21,23])))
					PLS[nop]=(str2num(LineofNote[28,31])*(10^str2num(lineofnote[33,35])))
					Rgchecker =  strsearch(LineofNote,"Rg",0)										
					SdRgchecker = strsearch(LineofNote,"StdDev(Rg)",0)
					Rschecker = strsearch(LineofNote,"Rs",0)
					Rg[nop]=str2num(LineofNote[(Rgchecker+3),(SdRgchecker-1)])
					StdDevRg[nop]=str2num(LineofNote[(SdRgchecker+11),(Rschecker-1)])
					Rs[nop]=str2num(LineofNote[(Rschecker+3),150])										
					nop=nop+1
			while(nop<(plchecker-1))
		//ASSIGNING THE PROPER NAMES TO THE LOADED WAVES
		name= name[1,28]
		       rwave="r"+name
			qwave="q"+name
			swave="s"+name
			qmodwave="qmod"+name
			rmodwave="rmod"+name
			qpsdwave="qpsd"+name
			rpsdwave="rpsd"+name
			//make/o $qwave,$rwave,$swave,$qmodwave,$rmodwave,$qpsdwave,$rpsdwave
						
			qwavename= stringfromlist((0),wavenames)
			rwavename=stringfromlist((1),wavenames)
			qmodwavename=stringfromlist((2),wavenames)
			rmodwavename=stringfromlist((3),wavenames)
			qpsdwavename=stringfromlist((4),wavenames)
			rpsdwavename=stringfromlist((5),wavenames)
					
			duplicate/o  $qwavename,$qwave
			duplicate/o  $rwavename,$rwave
			duplicate/o  $rwavename,$swave
			$swave*=.01
			duplicate/o  $qmodwavename,$qmodwave
			duplicate/o  $rmodwavename,$rmodwave
			duplicate/o  $qpsdwavename,$qpsdwave
			duplicate/o  $rpsdwavename,$rpsdwave
			
		Xa=qwave
		Ya=rwave
		Root:Packages:P:xvalue=Xa; Root:Packages:P:yvalue=Ya
		Display $Ya vs $Xa
		ModifyGraph log=1, tick=2,axThick=2,msize=2,mrkThick=3, mode=3,marker=19
		Legend/C/N=added2/J/A=MC"\\s('"+Ya+"')"+ya
	      Xa=qmodwave
		Ya=rmodwave
		Root:Packages:P:xvalue=Xa; Root:Packages:P:yvalue=Ya
	      Append $Ya vs $Xa
		//Legend/C/N=added2/J/A=MC"\\s('"+Ya+"')"+ya
		Modify log(bottom) =1
		Modify log(left)=1
		 ModifyGraph log=1, tick=2,axThick=2,msize=3,mrkThick=5, mode($Ya)=0,rgb($Ya)=(500,500,500),lSize=2, lStyle=0
		Xa=qpsdwave
		Ya=rpsdwave
		 Append $Ya vs $Xa
		ModifyGraph log=1, tick=2,axThick=2,msize=3,mrkThick=5, mode($Ya)=0,rgb($Ya)=(8000,500,500),lSize=2, lStyle($Ya)=3
	makemeasuredwave()//not debugged written by Ryan and DWS		
			//ASSIGNING NAMES TO THE POWER LAW REGIMES 
	nop = 0
	do		
		adder = num2str(nop+1)
		//print adder
		rpwave="rp"+adder+name
		qpwave="qp"+adder+name
		//make/o $rpwave $qpwave
		qpwavename= stringfromlist((6+(nop*2)),wavenames)
		rpwavename=stringfromlist((7+(nop*2)),wavenames)
		duplicate/o  $qpwavename,$qpwave
		duplicate/o  $rpwavename,$rpwave			
		Xa=qpwave
	       Ya=rpwave//put following in max's plotting code
	       Append $Ya vs $Xa
		red=FindString2num((nop+1),rcolortypes,";")
		green=FindString2num((nop+1),gcolortypes,";")
		blue=FindString2num((nop+1),bcolortypes,";")	      
		ModifyGraph  log=1, tick=2,axThick=2,msize($Ya)=3,mrkThick=2, mode($Ya)=0,marker=19, rgb($Ya)=(red, green, blue), lSize($Ya)=2, lStyle($Ya)=0
		literal="P = "+num2str(PLS[nop]) +"\rB = "+num2str(B[nop]) +"\rG = "+num2str(G[nop])+"\rRg= "+num2str(Rg[nop])+"\rStdDevRg = "+num2str(StdDevRg[nop])+"\rRs = "+num2str(Rs[nop])
		Tag $Ya,0,literal///L=0  
		//ChangetoLineandPoints(1,1)
		nop =nop +1		
	while(nop<(plchecker-1))				
		//if (Qloadall==1)
			//dowindow/k Graph0
		//endif
		//index=index+1	
	Modify grid=2,tick=2,minor=1,font="Times",zero(left)=1,standoff=0, mirror=1;DelayUpdate	 
	xaxislabel="\F'times new roman'\Z18\f01"+xlabel
	yaxislabel="\F'times new roman'\Z18\f01"+ylabel
	Label bottom xaxislabel;
	Label left yaxislabel;	
	ShowInfo;ShowTools		
	close refno
	killwaves/z w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w10, w11, w12, w13, w14, w15, linereader
	Newdatafolder /O/S Fitting_Parameters
	LoadWave/A = S_filename/J/D/ n=W/K=0/L= {0,0,0,0,2}S_filename//max put filename in
	rename W0 value
	rename W1 varname					
	setdatafolder root:		
		//while(qloadall==1)//don't recycle for single folder option
	if (qloadall==1)
	 	LoadMicromeriticsV1_08temp(1)//allow user to hand pick another file
	endif	
	end

Macro loadMicromeriticsDWS(qloadall)
	variable qloadall=2,linelimit=6000
	Prompt qLoadAll,"Load all data in a Folder?",popup,"All waves in folder (no Display);User picks waves one at a time (Displayed)"
	silent 1
	setdatafolder root:
	NewDataFolder/O MicromeriticsUC_SN_131
	variable index=0,Counter,length, refno
	String LineOfNote,theNote,name,rwave,swave,qwave,filename,samplename,path,fullpath,testnumstring,wavenames,qwavename,rwavename
	string/g Root:Packages:P:gfilename
	if (qloadall==2)//load one
		Open/R/T="TEXT"/m="Text file only" refno as filename//User picks a file
		getfilename(s_filename)
		fullpath=s_filename
		filename=Root:Packages:P:gfilename
		NewPath/O temporarypath Root:Packages:P:gpath//temporary path is not a defined string
	else //load all pick folder
			NewPath/O temporarypath //User picks a folder, temporary path is not a defined string
	endif
	variable Totaltests=0, qspace=0
	do//cycle through all text files in folder
		if(qloadall==1)//loading all files
			filename=IndexedFile(temporarypath, index, ".txt")
				if (strlen(filename)==0)//any more files?
					Killvariables/a/z;killstrings/a/z
					break  //always exit here when files are exhausted
				endif
			Open /R/T="TEXT"/m="Text file only"/P=temporarypath refno as filename
			getfilename(s_filename)
			fullpath=s_filename
		endif
		//put initial lines in note of wave and set up a data folder based on the sample ID in text file
		counter=0
		TheNote=filename+"\r"
		do//get the header information
			FReadLine refNo, LineOfNote	
			TheNote+=LineOfNote
				if (stringmatch(LineofNote, "*Sample*" ))
					print "sample line = "+lineofnote
					samplename=Getnamechanges(lineofnote)
					//length =strlen(lineofnote)
					//samplename=lineOfNote[10, (length-4)]
					samplename=CleanupName(samplename,0)	
				endif
			Counter+=1
		while(Counter<17)
		length =strlen(filename)
		name="M"+filename[0,(length-9)]+"_"+samplename//may have to eliminate more for .rep.text
		name=cleanupName(name,0)
		name=name[0,28]
		NewDataFolder/O/S $name
		make/o/n=8 tests
		//data loading
		
		do//find the background intensity
			FReadLine refno, LineOfNote
			counter=counter+1
			If (stringmatch(LineofNote, "Background Intensity vs*" ))
				Print "\r"+(num2str(counter))+" "+lineofnote
				break 
			endif	
		while (counter<linelimit)		
		if (counter==linelimit)//exceeded the line limit must not be any more tests
			DoAlert 0, "Line limit exceeded. No backgrouund found."
			break
			
		endif
		
		//load the backgraound waves
		LoadWave/n/g/k=1/L={0,(counter+5),465,0,2} fullpath

		
		//find a Sample waves
		totaltests=0
		
		do
			FReadLine refNo, LineOfNote
			counter=counter+1
			if (stringmatch(LineofNote, "Goodness of Fit*" ))
				Print (num2str(counter))+" "+lineofnote
				LoadWave/n/g/n=w/k=1/L={0,(counter+2),0,0,2} fullpath//all the rest must be sample waves, load them
				wavenames=s_wavenames
			endif
			If (stringmatch(LineofNote, "test*" ))//Does the line contain a test number?
				testnumstring = lineofnote[5]//pick off the test number
				tests[totaltests]=str2num(testnumstring)//tests is a wave that stores the test numbers
				totaltests=totaltests+1
			endif	
			If  (stringmatch(LineofNote, "Scattering vector*" ))//q or angle?
				qspace=1
			endif
				
		while (counter<linelimit)
		//parse the waves into tests
		counter = 0
		do
			if (totaltests==1)
				testnumstring=""
			else
				testnumstring="_"+num2str(tests[counter])
			endif
			//print "test = "+testnumstring[1]
			rwave="r"+name+testnumstring
			swave="s"+name+testnumstring
			qwave="q"+name+testnumstring
			make/o $qwave,$rwave,$swave
			qwavename= stringfromlist((2*counter),wavenames)
			rwavename=stringfromlist((1+2*counter),wavenames)
			duplicate/o  $qwavename,$qwave
			duplicate/o  $rwavename,$rwave
			duplicate/o  $rwavename,$swave
			if (qspace==0)
				$qwave=(4*pi*1.33/6580)*sin ($qwave*pi/360)
			endif
			$swave=0.01*$rwave
			Note $rwave TheNote
			
			If (counter==0)//first test
				Display $rwave vs $qwave
			else
				AppendToGraph $rwave vs $qwave
			endif	
			ChangetoLineandPoints(4,1)	
			ModifyGraph log=1, tick=2,axThick=2,msize=1,mrkThick=3, mode=3,marker=19
			AddErrorWaves()
			Legend/C/N=text1/A=MC
			counter=counter+1
		while (counter<(totaltests))//cycles through tests in same refno file
	
		make/o qzbkg,rzbkg,szbkg
		duplicate/o wave0,qzbkg;duplicate/o wave1,rzbkg;duplicate/o wave1,szbkg
		szbkg=0.01*szbkg
		qzbkg=(4*pi*1.33/6580)*sin (qzbkg*pi/360)
		killwaves/z wave0, wave1
		appendtograph rzbkg vs qzbkg
		
		close refno
		killwaves/a/z
		if (Qloadall==1)
			//dowindow/k Graph0
		endif
		index=index+1
		setdatafolder root:
	while(qloadall==1)//don't recycle for single folder option
	if (qloadall==2)
	 	LoadMicromeriticsTXT1(2)//allow user to hand pick another file
	endif	
end
